<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Dtos\Common\UserIdsDTO;
use Erlage\Photogram\Data\Dtos\User\UserDisplayImageDTO;
use Erlage\Photogram\Data\Dtos\User\UserMetaPushSettingsDTO;

trait TraitUserGetters
{
    use TraitUserProperties;

    /*
    |--------------------------------------------------------------------------
    | Note! We could have all our properties as public. The reason for using 
    | getters is that static checking doesn't work well for undefined properties
    | because of dynamic properties in PHP(__set & __get methods)
    |--------------------------------------------------------------------------
    */

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getEmail(): string
    {
        return $this -> email;
    }

    public function getUsername(): string
    {
        return $this -> username;
    }

    public function getPassword(): string
    {
        return $this -> password;
    }

    public function getDisplayName(): string
    {
        return $this -> displayName;
    }

    public function getDisplayBio(): string
    {
        return $this -> displayBio;
    }

    public function getDisplayImage(): UserDisplayImageDTO
    {
        return $this -> displayImage;
    }

    public function getDisplayWeb(): string
    {
        return $this -> displayWeb;
    }

    public function getMetaAccess(): string
    {
        return $this -> metaAccess;
    }

    public function getMetaIsPrivate(): string
    {
        return $this -> metaIsPrivate;
    }

    public function getMetaIsEmailVerified(): string
    {
        return $this -> metaIsEmailVerified;
    }

    public function getMetaLastActive(): string
    {
        return $this -> metaLastActive;
    }

    public function getMetaPushSettings(): UserMetaPushSettingsDTO
    {
        return $this -> metaPushSettings;
    }

    public function getCachePostsCount(): string
    {
        return $this -> cachePostsCount;
    }

    public function getCacheFollowersCount(): string
    {
        return $this -> cacheFollowersCount;
    }

    public function getCacheFollowingsCount(): string
    {
        return $this -> cacheFollowingsCount;
    }

    public function getCacheBlockedUserIds(): UserIdsDTO
    {
        return $this -> cacheBlockedUserIds;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
